/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.os;

import java.util.BitSet;
import java.util.StringJoiner;

public final class CpuMask {
    private final long mask;

    private CpuMask(long mask) {
        this.mask = mask;
    }

    public static CpuMask ofCpu(int cpuIndex) {
        return new CpuMask(1L << cpuIndex);
    }

    public static CpuMask ofCpus(int ... cpuIndices) {
        long m = 0L;
        for (int i : cpuIndices) {
            if (i < 0 || i >= 64) {
                throw new IllegalArgumentException("CPU index out of range: " + i);
            }
            m |= 1L << i;
        }
        return new CpuMask(m);
    }

    public static CpuMask allFrom(int startInclusive, int endExclusive) {
        if (startInclusive < 0 || endExclusive > 64 || startInclusive >= endExclusive) {
            throw new IllegalArgumentException("Invalid range");
        }
        long m = 0L;
        for (int i = startInclusive; i < endExclusive; ++i) {
            m |= 1L << i;
        }
        return new CpuMask(m);
    }

    public long toLong() {
        return this.mask;
    }

    public String toString() {
        BitSet set = BitSet.valueOf(new long[]{this.mask});
        StringJoiner sj = new StringJoiner(",");
        int i = set.nextSetBit(0);
        while (i >= 0) {
            sj.add(Integer.toString(i));
            i = set.nextSetBit(i + 1);
        }
        return "CpuMask[" + sj.toString() + "]";
    }
}

