/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.policy;

import com.abdik.shiro.security.SecurityPolicy;
import java.io.FilePermission;
import java.lang.reflect.ReflectPermission;
import java.net.SocketPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.PropertyPermission;

public final class CustomPolicy
extends Policy {
    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions perms = new Permissions();
        for (String path : SecurityPolicy.getAllowedPaths()) {
            Object canonicalPath = path.endsWith("/") ? path : path + "/";
            perms.add(new FilePermission((String)canonicalPath + "-", "read,write,delete"));
        }
        perms.add(new PropertyPermission("*", "read"));
        perms.add(new ReflectPermission("suppressAccessChecks"));
        perms.add(new RuntimePermission("accessDeclaredMembers"));
        perms.add(new RuntimePermission("getStackTrace"));
        perms.add(new RuntimePermission("modifyThread"));
        perms.add(new RuntimePermission("modifyThreadGroup"));
        perms.add(new RuntimePermission("accessClassInPackage.sun.*"));
        perms.add(new RuntimePermission("accessClassInPackage.java.*"));
        perms.add(new SocketPermission("localhost:0-", "connect,resolve,accept"));
        perms.add(new RuntimePermission("accessSystemModules"));
        perms.setReadOnly();
        return perms;
    }

    @Override
    public void refresh() {
        try {
            SecurityPolicy.reloadAllowedPaths();
        }
        catch (Exception e) {
            System.err.println("[Shiro-Policy] Failed to refresh security policy: " + String.valueOf(e));
        }
    }
}

