/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.runtime;

import com.abdik.shiro.vm.ThreadLocalFix;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ThreadMonitor {
    private static final Set<Long> knownThreadIds = Collections.synchronizedSet(new HashSet());
    private static final Map<Long, Long> threadCreationTimestamps = Collections.synchronizedMap(new HashMap());
    private static final long MIN_THREAD_LIFETIME_MS = 2400000L;

    private ThreadMonitor() {
    }

    public static void init() {
        Thread.getAllStackTraces().keySet().forEach(t -> {
            knownThreadIds.add(t.getId());
            threadCreationTimestamps.put(t.getId(), System.currentTimeMillis());
        });
    }

    public static void killOrphanThreads() {
        ThreadLocalFix.nukeCurrentThreadLocals();
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            long threadId = t.getId();
            long threadCreationTime = threadCreationTimestamps.getOrDefault(threadId, -1L);
            if (threadCreationTime == -1L || knownThreadIds.contains(threadId) || t.isDaemon() || !t.isAlive()) continue;
            long elapsedTime = System.currentTimeMillis() - threadCreationTime;
            if (elapsedTime < 2400000L) {
                try {
                    System.out.println("[Shiro] Killing orphan thread: " + t.getName());
                    t.interrupt();
                    t.join(2000L);
                    if (!t.isAlive()) continue;
                    System.out.println("[Shiro] Force-stopping stubborn thread: " + t.getName());
                    t.stop();
                }
                catch (Throwable throwable) {}
                continue;
            }
            System.out.println("[Shiro] Skipping orphan thread due to age: " + t.getName());
        }
    }
}

