/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.security;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SecurityPolicy {
    private static final String[] ALLOWED_ROOTS = new String[]{"mods", "shaderpacks", "resourcepacks", "config", "screenshots", "saves"};
    private static volatile List<String> allowedPaths;

    private SecurityPolicy() {
    }

    public static boolean isAllowedPath(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        File file = new File(path);
        try {
            String target = file.getCanonicalPath();
            for (String allowed : SecurityPolicy.getAllowedPaths()) {
                if (!target.startsWith(allowed)) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getAllowedPaths() {
        if (allowedPaths != null) return allowedPaths;
        Class<SecurityPolicy> clazz = SecurityPolicy.class;
        synchronized (SecurityPolicy.class) {
            if (allowedPaths != null) return allowedPaths;
            allowedPaths = SecurityPolicy.computeAllowedPaths();
            // ** MonitorExit[var0] (shouldn't be in output)
            return allowedPaths;
        }
    }

    public static void reloadAllowedPaths() {
        allowedPaths = SecurityPolicy.computeAllowedPaths();
    }

    private static List<String> computeAllowedPaths() {
        String mcDir = System.getProperty("user.dir");
        ArrayList<String> list = new ArrayList<String>(ALLOWED_ROOTS.length);
        for (String root : ALLOWED_ROOTS) {
            try {
                String canonical = new File(mcDir, root).getCanonicalPath();
                list.add(canonical);
            }
            catch (IOException e) {
                System.err.println("[SecurityPolicy] Failed to resolve path: " + root);
            }
        }
        return Collections.unmodifiableList(list);
    }
}

