/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.util;

import com.abdik.shiro.ModConfig;
import com.abdik.shiro.ShiroMod;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class JVMWatchdog
implements Runnable {
    private final ModConfig config;
    private volatile long lastUsedTimestamp;

    public JVMWatchdog(ModConfig config) {
        this.config = config;
        this.lastUsedTimestamp = System.currentTimeMillis();
    }

    public void notifyActivity() {
        this.lastUsedTimestamp = System.currentTimeMillis();
    }

    @Override
    public void run() {
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    long now = System.currentTimeMillis();
                    long idleMillis = now - this.lastUsedTimestamp;
                    long idleLimitMillis = (long)(this.config.unusedClearMinutes * 60.0 * 1000.0);
                    MemoryUsage heapUsage = memoryBean.getHeapMemoryUsage();
                    long usedHeap = heapUsage.getUsed();
                    long maxHeap = heapUsage.getMax();
                    double usageRatio = (double)usedHeap / (double)maxHeap;
                    if (idleMillis > idleLimitMillis && this.config.enableHardCleanup && usageRatio > this.config.hardCleanupThreshold) {
                        ShiroMod.hardCleanup();
                        this.notifyActivity();
                    }
                    if (!this.config.logCleanupStats) continue;
                    System.out.printf("[JVMWatchdog] Heap usage: %.2f%%, Idle time: %.2f min%n", usageRatio * 100.0, (double)idleMillis / 60000.0);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

