/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.util;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;

public class ObjectPool<T> {
    private final ConcurrentLinkedQueue<T> pool = new ConcurrentLinkedQueue();
    private final Supplier<T> creator;
    private final int maxSize;

    public ObjectPool(Supplier<T> creator, int maxSize) {
        this.creator = creator;
        this.maxSize = maxSize;
    }

    public T borrow() {
        T obj = this.pool.poll();
        return obj != null ? obj : this.creator.get();
    }

    public void recycle(T obj) {
        if (this.pool.size() < this.maxSize) {
            this.pool.offer(obj);
        }
    }
}

