/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;

public class ShiroLimiterConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("ShiroLimiter.json");
    private static Map<String, Boolean> modLimits = new HashMap<String, Boolean>();

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                Type type = new TypeToken<Map<String, Map<String, Boolean>>>(){}.getType();
                Map root = (Map)GSON.fromJson((Reader)reader, type);
                if (root != null && root.containsKey("mods")) {
                    modLimits = (Map)root.get("mods");
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load ShiroLimiter config: " + e.getMessage());
                e.printStackTrace();
            }
        }
        Set installedMods = FabricLoader.getInstance().getAllMods().stream().map(m -> m.getMetadata().getId()).collect(Collectors.toSet());
        boolean changed = false;
        for (String modId : installedMods) {
            if (modLimits.containsKey(modId)) continue;
            modLimits.put(modId, true);
            changed = true;
        }
        if (changed) {
            ShiroLimiterConfig.save();
        }
    }

    public static synchronized void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                HashMap<String, Map<String, Boolean>> root = new HashMap<String, Map<String, Boolean>>();
                root.put("mods", modLimits);
                GSON.toJson(root, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("[ShiroLimiterConfig] Failed to save: " + e.getMessage());
        }
    }

    public static boolean isLimited(String modId) {
        return modLimits.getOrDefault(modId, true);
    }

    public static void setLimit(String modId, boolean enabled) {
        modLimits.put(modId, enabled);
        ShiroLimiterConfig.save();
    }

    public static Map<String, Boolean> getAllLimits() {
        return new HashMap<String, Boolean>(modLimits);
    }
}

