/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.vm;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.lang.management.ManagementFactory;

public class VMOptionTuner {
    public static void applyJVMOptions() {
        try {
            HotSpotDiagnosticMXBean hsBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
            if (hsBean == null) {
                System.out.println("[Shiro-VM] HotSpotDiagnosticMXBean not available on this JVM.");
                return;
            }
            VMOptionTuner.setVMOption(hsBean, "MaxHeapFreeRatio", "40");
            VMOptionTuner.setVMOption(hsBean, "MinHeapFreeRatio", "10");
            VMOptionTuner.setVMOption(hsBean, "UseStringDeduplication", "true");
            VMOptionTuner.setVMOption(hsBean, "AlwaysPreTouch", "true");
            VMOptionTuner.setVMOption(hsBean, "UseNUMA", "false");
        }
        catch (Throwable t) {
            System.err.println("[Shiro-VM] VMOptionTuner failed: " + String.valueOf(t));
        }
    }

    private static void setVMOption(HotSpotDiagnosticMXBean hsBean, String name, String value) {
        try {
            hsBean.setVMOption(name, value);
            System.out.println("[Shiro-VM] Set VM option: " + name + "=" + value);
        }
        catch (Throwable t) {
            System.out.println("[Shiro-VM] Could not set VM option " + name + ": " + t.getMessage());
        }
    }
}

