/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.vm.low;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public final class ClassloaderLeakBreaker {
    private static final Set<ClassLoader> trackedLoaders = Collections.newSetFromMap(new WeakHashMap());

    public static void trackClassLoader(ClassLoader loader) {
        if (loader != null) {
            trackedLoaders.add(loader);
        }
    }

    public static void breakLeaks() {
        for (ClassLoader loader : trackedLoaders) {
            if (loader == null) continue;
            try {
                ClassloaderLeakBreaker.clearInternalCaches(loader);
            }
            catch (Throwable throwable) {}
        }
        trackedLoaders.clear();
    }

    private static void clearInternalCaches(ClassLoader loader) throws Exception {
        for (Field field : loader.getClass().getDeclaredFields()) {
            if (!Map.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            Object mapObj = field.get(loader);
            if (!(mapObj instanceof Map)) continue;
            Map map = (Map)mapObj;
            map.clear();
        }
    }
}

