/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.vm.low;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;

public final class HiddenCleanupOps {
    private HiddenCleanupOps() {
    }

    public static void runLowLevelCleanups() {
        HiddenCleanupOps.flushIntrospectorCaches();
        HiddenCleanupOps.runJavaCleanerSweep();
        HiddenCleanupOps.scrubThreadLocalsFromModdedThreads();
    }

    private static void flushIntrospectorCaches() {
        try {
            Introspector.flushCaches();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void runJavaCleanerSweep() {
        try {
            Class<?> cleanerClass = Class.forName("jdk.internal.ref.Cleaner");
            Method getCleanerMethod = cleanerClass.getDeclaredMethod("create", new Class[0]);
            getCleanerMethod.setAccessible(true);
            Object cleaner = getCleanerMethod.invoke(null, new Object[0]);
            Method cleanMethod = cleanerClass.getDeclaredMethod("clean", new Class[0]);
            cleanMethod.setAccessible(true);
            cleanMethod.invoke(cleaner, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void scrubThreadLocalsFromModdedThreads() {
        try {
            Set<Thread> threads = Thread.getAllStackTraces().keySet();
            for (Thread t : threads) {
                try {
                    if (t.getThreadGroup() != null && "system".equalsIgnoreCase(t.getThreadGroup().getName())) continue;
                    ClassLoader cl = t.getContextClassLoader();
                    if (cl != null && !HiddenCleanupOps.isSystemClassLoader(cl)) {
                        t.setContextClassLoader(null);
                    }
                    Field targetField = Thread.class.getDeclaredField("target");
                    targetField.setAccessible(true);
                    Object target = targetField.get(t);
                    if (target != null && !HiddenCleanupOps.isJDKClass(target.getClass())) {
                        targetField.set(t, null);
                    }
                    Field inheritable = Thread.class.getDeclaredField("inheritableThreadLocals");
                    inheritable.setAccessible(true);
                    inheritable.set(t, null);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean isJDKClass(Class<?> cls) {
        String name = cls.getName();
        return name.startsWith("java.") || name.startsWith("jdk.") || name.startsWith("sun.") || name.startsWith("com.sun.");
    }

    private static boolean isSystemClassLoader(ClassLoader cl) {
        return cl == ClassLoader.getSystemClassLoader() || cl.getClass().getName().startsWith("jdk.") || cl.getClass().getName().startsWith("sun.");
    }
}

