/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.cpu;

import java.util.concurrent.atomic.AtomicReference;

public class LockFreeQueue<T> {
    private final AtomicReference<Node<T>> head;
    private final AtomicReference<Node<T>> tail;

    public LockFreeQueue() {
        Node<Object> dummy = new Node<Object>(null);
        this.head = new AtomicReference<Node<Object>>(dummy);
        this.tail = new AtomicReference<Node<Object>>(dummy);
    }

    public void enqueue(T value) {
        Node<T> newNode = new Node<T>(value);
        Node<T> oldTail = this.tail.getAndSet(newNode);
        oldTail.next = newNode;
    }

    public T dequeue() {
        Node<T> oldHead = this.head.get();
        Node newHead = oldHead.next;
        if (newHead == null) {
            return null;
        }
        this.head.set(newHead);
        return newHead.value;
    }

    private static class Node<T> {
        final T value;
        volatile Node<T> next;

        Node(T value) {
            this.value = value;
        }
    }
}

