/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.io;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class FileSystemWatcher
implements Runnable {
    private final WatchService watcher = FileSystems.getDefault().newWatchService();

    public FileSystemWatcher(Path pathToWatch) throws IOException {
        pathToWatch.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    @Override
    public void run() {
        try {
            while (true) {
                WatchKey key = this.watcher.take();
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    Path filename = (Path)event.context();
                    System.out.println("[ShiroIO] File event: " + String.valueOf(kind) + " on " + String.valueOf(filename));
                }
                key.reset();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }
}

