/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.io;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class MemoryMappedIO {
    public static MappedByteBuffer mapFileReadOnly(Path path) throws IOException {
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            return mappedByteBuffer;
        }
    }

    public static MappedByteBuffer mapFileReadWrite(Path path, long size) throws IOException {
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
            return mappedByteBuffer;
        }
    }
}

