/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.overlay;

import com.abdik.shiro.cpu.SystemCpuMonitor;
import java.awt.Color;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class CPUOverlay {
    public static boolean ENABLED = false;
    private static final int GRAPH_WIDTH = 100;
    private static final int GRAPH_HEIGHT = 30;
    private static final int[] cpuHistory = new int[100];
    private static int updateTick = 0;

    public static void register() {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> CPUOverlay.render(drawContext));
    }

    private static void render(class_332 context) {
        if (!ENABLED) {
            return;
        }
        double usage = SystemCpuMonitor.getCpuUsage();
        double usagePercent = usage * 100.0;
        class_310 mc = class_310.method_1551();
        class_327 tr = mc.field_1772;
        int x = 4;
        int y = 60;
        String text = String.format("CPU: %.1f%%", usagePercent);
        int color = CPUOverlay.getGradientColor(usagePercent, 120.0f, 60.0f);
        context.method_51439(tr, (class_2561)class_2561.method_43470((String)text), x + 1, y + 1, -16777216, false);
        context.method_51439(tr, (class_2561)class_2561.method_43470((String)text), x, y, color, false);
        if (updateTick++ % 10 == 0) {
            System.arraycopy(cpuHistory, 1, cpuHistory, 0, 99);
            CPUOverlay.cpuHistory[99] = (int)(usage * 30.0);
        }
        int graphX = x;
        int graphY = y + 12;
        for (int i = 0; i < 100; ++i) {
            int barHeight = cpuHistory[i];
            int barColor = CPUOverlay.getGradientColor((float)barHeight / 30.0f * 100.0f, 120.0f, 60.0f);
            context.method_25294(graphX + i, graphY + 30 - barHeight, graphX + i + 1, graphY + 30, barColor);
        }
    }

    private static int getGradientColor(double percent, float startHueDeg, float endHueDeg) {
        percent = Math.max(0.0, Math.min(percent, 100.0));
        float hue = (float)((double)startHueDeg + (double)(endHueDeg - startHueDeg) * (percent / 100.0)) / 360.0f;
        Color color = Color.getHSBColor(hue, 0.75f, 1.0f);
        return 0xFF000000 | color.getRGB() & 0xFFFFFF;
    }
}

