/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.gpu;

import com.abdik.shiro.gpu.GPUInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class GPUCapDetector {
    public static boolean isGPUBottlenecked() {
        int gpuUtil = GPUInfo.getUtilization();
        int cpuLoad = GPUCapDetector.getCpuLoad();
        return gpuUtil > 80 && cpuLoad < 50;
    }

    private static int getCpuLoad() {
        try {
            String[] parts;
            Process p = Runtime.getRuntime().exec("top -bn2 | grep 'Cpu(s)' | tail -n1");
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = reader.readLine();
            if (line == null) {
                return 0;
            }
            for (String part : parts = line.split(",")) {
                if (!part.contains("id")) continue;
                String idleStr = part.trim().split(" ")[0];
                float idle = Float.parseFloat(idleStr);
                return (int)(100.0f - idle);
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

