/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.gpu;

import com.abdik.shiro.gpu.GPUVendor;
import com.abdik.shiro.natives.NativeLoader;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class GPUInfo {
    private static boolean initialized = false;
    private static String gpuModel = "";
    private static GPUVendor cachedVendor = GPUVendor.UNKNOWN;

    private static void initGpuInfo() {
        block24: {
            if (initialized) {
                return;
            }
            initialized = true;
            cachedVendor = GPUInfo.getVendorNative();
            try {
                if (cachedVendor == GPUVendor.NVIDIA) {
                    Process process = Runtime.getRuntime().exec("nvidia-smi --query-gpu=name --format=csv,noheader");
                    process.waitFor();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        gpuModel = reader.readLine();
                        break block24;
                    }
                }
                if (cachedVendor == GPUVendor.AMD) {
                    Process process = Runtime.getRuntime().exec("rocm-smi --showproductname -d 0");
                    process.waitFor();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (!line.contains("Product Name")) continue;
                            gpuModel = line.split(":")[1].trim();
                            break block24;
                        }
                        break block24;
                    }
                }
                if (cachedVendor != GPUVendor.INTEL) break block24;
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", "lspci | grep -i 'intel.*vga'"});
                    process.waitFor();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        int colonIndex;
                        String line = reader.readLine();
                        gpuModel = line != null ? ((colonIndex = line.indexOf(": ")) != -1 && line.length() > colonIndex + 2 ? line.substring(colonIndex + 2).trim() : "Intel GPU (unknown model)") : "Intel GPU (unknown model)";
                    }
                }
                catch (Exception e) {
                    gpuModel = "Intel GPU (detection failed)";
                }
            }
            catch (Throwable ignored) {
                gpuModel = "";
            }
        }
        if (gpuModel == null || gpuModel.isEmpty()) {
            gpuModel = "Unknown GPU Model";
        }
        System.out.println("[GPUInfo] Detected vendor: " + String.valueOf((Object)cachedVendor));
        System.out.println("[GPUInfo] GPU Model: " + gpuModel);
    }

    private static GPUVendor getVendorNative() {
        try {
            return GPUVendor.fromCode(GPUInfo.nativeGetVendor());
        }
        catch (Throwable t) {
            return GPUVendor.UNKNOWN;
        }
    }

    public static int getMemoryMB() {
        int mem = GPUInfo.nativeMemoryMB();
        return mem >= 0 ? mem : 0;
    }

    public static int getUtilization() {
        int util = GPUInfo.nativeUtilization();
        return util >= 0 ? util : 0;
    }

    public static GPUVendor getVendor() {
        return cachedVendor;
    }

    public static String getModel() {
        return gpuModel;
    }

    public static void debugNativeStats() {
        try {
            System.out.println("[GPUInfo] Vendor code: " + GPUInfo.nativeGetVendor());
            System.out.println("[GPUInfo] Utilization: " + GPUInfo.nativeUtilization());
            System.out.println("[GPUInfo] Memory MB: " + GPUInfo.nativeMemoryMB());
        }
        catch (Throwable t) {
            System.err.println("[GPUInfo] Native call failed: " + t.getMessage());
        }
    }

    public static native int nativeMemoryMB();

    public static native int nativeUtilization();

    public static native int nativeGetVendor();

    public static void logBasicInfo() {
        System.out.println("[GPUInfo] Detected vendor: " + String.valueOf((Object)cachedVendor));
        System.out.println("[GPUInfo] GPU Model: " + gpuModel);
    }

    static {
        NativeLoader.load();
        GPUInfo.initGpuInfo();
    }
}

