/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.io;

import com.abdik.shiro.io.IOPerfGovernor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class AsyncIODispatcher {
    private static final int BUFFER_SIZE = 8192;
    private static ExecutorService executorService;

    public static void init() {
        int threads = IOPerfGovernor.getMaxConcurrentIOThreads();
        executorService = Executors.newFixedThreadPool(threads);
    }

    public static void asyncRead(Path path, final Consumer<ByteBuffer> onComplete, final Consumer<Throwable> onError) {
        try {
            EnumSet<StandardOpenOption> options = EnumSet.of(StandardOpenOption.READ);
            final AsynchronousFileChannel channel = AsynchronousFileChannel.open(path, options, executorService, new FileAttribute[0]);
            ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
            channel.read(buffer, 0L, buffer, new CompletionHandler<Integer, ByteBuffer>(){

                @Override
                public void completed(Integer result, ByteBuffer attachment) {
                    attachment.flip();
                    onComplete.accept(attachment);
                    AsyncIODispatcher.closeQuietly(channel);
                }

                @Override
                public void failed(Throwable exc, ByteBuffer attachment) {
                    onError.accept(exc);
                    AsyncIODispatcher.closeQuietly(channel);
                }
            });
        }
        catch (IOException e) {
            onError.accept(e);
        }
    }

    public static void asyncWrite(Path path, ByteBuffer data, final Consumer<Void> onComplete, final Consumer<Throwable> onError) {
        try {
            EnumSet<StandardOpenOption> options = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            final AsynchronousFileChannel channel = AsynchronousFileChannel.open(path, options, executorService, new FileAttribute[0]);
            channel.write(data, 0L, data, new CompletionHandler<Integer, ByteBuffer>(){

                @Override
                public void completed(Integer result, ByteBuffer attachment) {
                    onComplete.accept(null);
                    AsyncIODispatcher.closeQuietly(channel);
                }

                @Override
                public void failed(Throwable exc, ByteBuffer attachment) {
                    onError.accept(exc);
                    AsyncIODispatcher.closeQuietly(channel);
                }
            });
        }
        catch (IOException e) {
            onError.accept(e);
        }
    }

    public static void shutdown() {
        if (executorService != null && !executorService.isShutdown()) {
            executorService.shutdownNow();
        }
    }

    private static void closeQuietly(AsynchronousFileChannel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

