/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.network;

import com.abdik.shiro.network.SocketOptionsTuner;
import com.abdik.shiro.network.WrappedSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SilentSocketPool {
    private static final int MAX_POOL_SIZE = 50;
    private static final ConcurrentLinkedQueue<WrappedSocket> pool = new ConcurrentLinkedQueue();

    public static WrappedSocket acquire(String host, int port) throws IOException {
        WrappedSocket socket;
        while (true) {
            if ((socket = pool.poll()) == null) {
                return new WrappedSocket(host, port);
            }
            if (socket.isClosed() || !socket.isConnected() || socket.isInputShutdown() || socket.isOutputShutdown()) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            if (socket.isConnected()) break;
            try {
                socket.connect(new InetSocketAddress(host, port));
            }
            catch (IOException e) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            break;
        }
        return socket;
    }

    public static void release(WrappedSocket socket) {
        if (socket == null) {
            return;
        }
        if (pool.size() >= 50) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        if (socket.isClosed()) {
            return;
        }
        SocketOptionsTuner.apply(socket);
        pool.offer(socket);
    }

    public static void clear() {
        WrappedSocket socket;
        while ((socket = pool.poll()) != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static int size() {
        return pool.size();
    }
}

