/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.security;

import com.abdik.shiro.security.NetworkSecurity;
import java.security.Permission;

public class CustomSecurityManager
extends SecurityManager {
    private static boolean enabled = false;

    public static void enable() {
        enabled = true;
        NetworkSecurity.setFirewallActive(true);
    }

    public static void disable() {
        enabled = false;
        NetworkSecurity.setFirewallActive(false);
    }

    public static boolean isEnabled() {
        return enabled;
    }

    @Override
    public void checkPermission(Permission perm) {
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
    }

    @Override
    public void checkConnect(String host, int port) {
        if (!enabled) {
            return;
        }
        if (!NetworkSecurity.isAllowedPort(port)) {
            throw new SecurityException("Connection to port " + port + " blocked by CustomSecurityManager.");
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (!enabled) {
            return;
        }
        if (!NetworkSecurity.isAllowedPort(port)) {
            throw new SecurityException("Connection to port " + port + " blocked by CustomSecurityManager.");
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (!enabled) {
            return;
        }
        if (!NetworkSecurity.isAllowedPort(port)) {
            throw new SecurityException("Accept from port " + port + " blocked by CustomSecurityManager.");
        }
    }
}

