/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.cpu;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class NUMAOptimizedThreadPool {
    private final ExecutorService executorService;

    public NUMAOptimizedThreadPool(int numThreads) {
        this.executorService = Executors.newFixedThreadPool(numThreads, new NUMAThreadFactory());
    }

    public void submitTask(Runnable task) {
        this.executorService.submit(task);
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    private static class NUMAThreadFactory
    implements ThreadFactory {
        private NUMAThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            return thread;
        }
    }
}

