/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.hooks;

import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;

public final class LowLevelCleanupHook {
    private LowLevelCleanupHook() {
    }

    public static void run() {
        try {
            LowLevelCleanupHook.drainReferenceQueues();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            LowLevelCleanupHook.flushEnumCaches();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            LowLevelCleanupHook.patchLookupLeak();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            LowLevelCleanupHook.pruneThreadGroups();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void drainReferenceQueues() {
        System.gc();
        List<SoftReference<Object>> refs = List.of(new WeakReference<Object>(new Object()), new SoftReference<Object>(new Object()));
        for (Reference reference : refs) {
            try {
                Reference polled;
                Field queueField = Reference.class.getDeclaredField("queue");
                queueField.setAccessible(true);
                Object q = queueField.get(reference);
                if (!(q instanceof ReferenceQueue)) continue;
                ReferenceQueue rq = (ReferenceQueue)q;
                while ((polled = rq.poll()) != null) {
                    polled.clear();
                }
            }
            catch (Throwable throwable) {
            }
        }
    }

    private static void flushEnumCaches() {
        try {
            for (Class<?> cls : LowLevelCleanupHook.getAllClasses()) {
                try {
                    Field enumConstantDir = Class.class.getDeclaredField("enumConstantDirectory");
                    enumConstantDir.setAccessible(true);
                    enumConstantDir.set(cls, null);
                }
                catch (Throwable enumConstantDir) {
                    // empty catch block
                }
                try {
                    Field enumConstants = Class.class.getDeclaredField("enumConstants");
                    enumConstants.setAccessible(true);
                    enumConstants.set(cls, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void patchLookupLeak() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Field f = MethodHandles.Lookup.class.getDeclaredField("lookupClass");
            f.setAccessible(true);
            f.set(lookup, Object.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void pruneThreadGroups() {
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        LowLevelCleanupHook.pruneGroupRecursive(root);
    }

    private static void pruneGroupRecursive(ThreadGroup group) {
        ThreadGroup[] subs = new ThreadGroup[group.activeGroupCount() + 1];
        int count = group.enumerate(subs, false);
        for (int i = 0; i < count; ++i) {
            LowLevelCleanupHook.pruneGroupRecursive(subs[i]);
        }
        if (group.activeCount() == 0 && group.activeGroupCount() == 0 && group != Thread.currentThread().getThreadGroup()) {
            try {
                Field parent = ThreadGroup.class.getDeclaredField("parent");
                parent.setAccessible(true);
                parent.set(group, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static Class<?>[] getAllClasses() {
        try {
            Class<?> clClass = Class.forName("java.lang.ClassLoader");
            Field f = clClass.getDeclaredField("classes");
            f.setAccessible(true);
            Object classes = f.get(ClassLoader.getSystemClassLoader());
            if (classes instanceof Vector) {
                Vector v = (Vector)classes;
                return v.toArray(new Class[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new Class[0];
    }
}

