/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.io;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ArrayBlockingQueue;

public class FileDescriptorPool {
    private static final int POOL_SIZE = 16;
    private static final ArrayBlockingQueue<FileChannel> pool = new ArrayBlockingQueue(16);

    public static void init(Path path) throws IOException {
        for (int i = 0; i < 16; ++i) {
            FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);
            pool.offer(fc);
        }
    }

    public static FileChannel acquire() throws InterruptedException {
        return pool.take();
    }

    public static void release(FileChannel fc) {
        if (fc != null) {
            pool.offer(fc);
        }
    }

    public static void closeAll() throws IOException {
        for (FileChannel fc : pool) {
            fc.close();
        }
        pool.clear();
    }
}

