/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.io;

import com.abdik.shiro.io.IOPerfGovernor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;

public class IOManager {
    private static final int BUFFER_SIZE = 8192;
    private static final List<Path> minecraftPaths = Arrays.asList(Paths.get(System.getProperty("user.home"), ".minecraft", "saves"), Paths.get(System.getProperty("user.home"), ".minecraft", "resourcepacks"), Paths.get(System.getProperty("user.home"), ".minecraft", "config"));

    public static void prefetchCriticalMinecraftPaths() {
        block7: for (Path path : minecraftPaths) {
            if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) continue;
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(path);
                try {
                    int count = 0;
                    for (Path entry : stream) {
                        entry.getFileName();
                        if (++count < 5) continue;
                        continue block7;
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void init() {
    }

    public static BufferedReader getOptimizedReader(Path path) throws IOException {
        return new BufferedReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0])), 8192);
    }

    public static BufferedWriter getOptimizedWriter(Path path) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0])), 8192);
    }

    public static byte[] fastReadAllBytes(Path path) throws IOException {
        return Files.readAllBytes(path);
    }

    public static int getMaxConcurrentIOThreads() {
        return IOPerfGovernor.getMaxConcurrentIOThreads();
    }
}

