/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.mixin;

import com.abdik.shiro.security.NetworkSecurity;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DatagramSocket.class}, remap=false)
public class MixinDatagramSocket {
    @Inject(method={"connect(Ljava/net/SocketAddress;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onConnect(SocketAddress endpoint, CallbackInfo ci) {
        InetSocketAddress inetAddress;
        int port;
        if (endpoint instanceof InetSocketAddress && !NetworkSecurity.isAllowedPort(port = (inetAddress = (InetSocketAddress)endpoint).getPort())) {
            ci.cancel();
            throw new SecurityException("DatagramSocket connection to port " + port + " blocked by Shiro.");
        }
    }

    @Inject(method={"bind(Ljava/net/SocketAddress;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onBind(SocketAddress endpoint, CallbackInfo ci) {
        InetSocketAddress inetAddress;
        int port;
        if (endpoint instanceof InetSocketAddress && !NetworkSecurity.isAllowedPort(port = (inetAddress = (InetSocketAddress)endpoint).getPort())) {
            ci.cancel();
            throw new SecurityException("DatagramSocket bind to port " + port + " blocked by Shiro.");
        }
    }
}

