/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.vm.low;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class FinalizerCleaner {
    private static Class<?> finalizerClass;
    private static Field queueField;
    private static Field nextField;
    private static Method finalizeMethod;

    public static void drainFinalizerQueue() {
        if (finalizerClass == null) {
            return;
        }
        try {
            Object head = queueField.get(null);
            while (head instanceof Reference) {
                Reference ref = (Reference)head;
                try {
                    finalizeMethod.invoke((Object)ref, new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                head = nextField.get(ref);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        try {
            finalizerClass = Class.forName("java.lang.ref.Finalizer");
            queueField = finalizerClass.getDeclaredField("queue");
            queueField.setAccessible(true);
            nextField = finalizerClass.getDeclaredField("next");
            nextField.setAccessible(true);
            finalizeMethod = finalizerClass.getDeclaredMethod("finalizeReferent", new Class[0]);
            finalizeMethod.setAccessible(true);
        }
        catch (Throwable t) {
            finalizerClass = null;
        }
    }
}

