/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.vm.low;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import sun.misc.Unsafe;

public final class OffHeapReferenceCleaner {
    private static final Unsafe UNSAFE;
    private static final Set<Buffer> trackedBuffers;

    public static void track(Buffer buffer) {
        if (buffer != null && buffer.isDirect()) {
            trackedBuffers.add(buffer);
        }
    }

    public static void cleanOrphaned() {
        for (Buffer buf : trackedBuffers) {
            if (buf == null || !buf.isDirect()) continue;
            try {
                long address = OffHeapReferenceCleaner.getAddress(buf);
                if (address == 0L || !(buf instanceof ByteBuffer)) continue;
                UNSAFE.invokeCleaner((ByteBuffer)buf);
            }
            catch (Throwable throwable) {}
        }
        trackedBuffers.clear();
    }

    private static long getAddress(Buffer buffer) throws Exception {
        Field addressField = Buffer.class.getDeclaredField("address");
        addressField.setAccessible(true);
        return (Long)addressField.get(buffer);
    }

    static {
        trackedBuffers = Collections.newSetFromMap(new WeakHashMap());
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            UNSAFE = (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

