/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.agent;

import com.abdik.shiro.agent.AgentBootstrap;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class AgentLoader {
    private AgentLoader() {
    }

    public static void loadAgentIfRequired() {
        try {
            if (AgentBootstrap.INSTRUMENTATION != null) {
                return;
            }
            String pid = AgentLoader.getPid();
            if (pid == null) {
                return;
            }
            String jarPath = AgentLoader.getOwnJarPath();
            if (jarPath == null) {
                return;
            }
            AgentLoader.attachAndLoadAgent(pid, jarPath);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String getPid() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            int at = name.indexOf(64);
            return at > 0 ? name.substring(0, at) : null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static String getOwnJarPath() {
        try {
            String path = AgentLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            Path p = Paths.get(path, new String[0]);
            return p.toAbsolutePath().toString();
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void attachAndLoadAgent(String pid, String jarPath) throws Exception {
        Class<?> vmClass = Class.forName("com.sun.tools.attach.VirtualMachine");
        Object vmInstance = vmClass.getMethod("attach", String.class).invoke(null, pid);
        try {
            vmClass.getMethod("loadAgent", String.class, String.class).invoke(vmInstance, jarPath, "");
        }
        finally {
            try {
                vmClass.getMethod("detach", new Class[0]).invoke(vmInstance, new Object[0]);
            }
            catch (Throwable throwable) {}
        }
    }
}

