/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.util;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;

public class ObjectPool<T> {
    private final ConcurrentLinkedQueue<T> pool = new ConcurrentLinkedQueue();
    private final Supplier<T> creator;

    public ObjectPool(Supplier<T> creator) {
        this.creator = creator;
    }

    public T borrow() {
        T obj = this.pool.poll();
        return obj != null ? obj : this.creator.get();
    }

    public void recycle(T obj) {
        this.pool.offer(obj);
    }
}

