/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro;

import java.awt.Color;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class MemoryOverlay {
    public static boolean ENABLED = false;
    private static final int GRAPH_WIDTH = 100;
    private static final int GRAPH_HEIGHT = 30;
    private static final int[] memoryHistory = new int[100];
    private static int updateTick = 0;

    public static void register() {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> MemoryOverlay.render(drawContext));
    }

    private static void render(class_332 context) {
        if (!ENABLED) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long used = runtime.totalMemory() - runtime.freeMemory();
        long max = runtime.maxMemory();
        double usageRatio = (double)used / (double)max;
        double usedMB = (double)used / 1024.0 / 1024.0;
        double maxMB = (double)max / 1024.0 / 1024.0;
        double usagePercent = usageRatio * 100.0;
        class_310 mc = class_310.method_1551();
        class_327 tr = mc.field_1772;
        int x = 4;
        int y = 4;
        String text = String.format("Mem: %.1f / %.1f MB (%.0f%%)", usedMB, maxMB, usagePercent);
        int color = MemoryOverlay.getPurplishGradientColor(usagePercent);
        context.method_51439(tr, (class_2561)class_2561.method_43470((String)text), x + 1, y + 1, -16777216, false);
        context.method_51439(tr, (class_2561)class_2561.method_43470((String)text), x, y, color, false);
        if (updateTick++ % 10 == 0) {
            System.arraycopy(memoryHistory, 1, memoryHistory, 0, 99);
            MemoryOverlay.memoryHistory[99] = (int)(usageRatio * 30.0);
        }
        int graphX = x;
        int graphY = y + 12;
        for (int i = 0; i < 100; ++i) {
            int barHeight = memoryHistory[i];
            int barColor = MemoryOverlay.getPurplishGradientColor((float)barHeight / 30.0f * 100.0f);
            context.method_25294(graphX + i, graphY + 30 - barHeight, graphX + i + 1, graphY + 30, barColor);
        }
    }

    private static int getPurplishGradientColor(double usagePercent) {
        usagePercent = Math.max(0.0, Math.min(usagePercent, 100.0));
        float startHue = 0.75f;
        float endHue = 0.8888889f;
        float hue = (float)((double)startHue + (double)(endHue - startHue) * (usagePercent / 100.0));
        float saturation = 0.65f;
        float brightness = 1.0f;
        Color color = Color.getHSBColor(hue, saturation, brightness);
        return 0xFF000000 | color.getRGB() & 0xFFFFFF;
    }
}

