/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro;

import com.abdik.shiro.MemoryOverlay;
import com.abdik.shiro.ModConfig;
import com.abdik.shiro.agent.AgentLoader;
import com.abdik.shiro.commands.MemCommand;
import com.abdik.shiro.commands.MemDevCommand;
import com.abdik.shiro.hooks.LowLevelCleanupHook;
import com.abdik.shiro.natives.MemOps;
import com.abdik.shiro.runtime.ShiroRuntime;
import com.abdik.shiro.util.DeepNullifier;
import com.abdik.shiro.util.DirectBufferForceFree;
import com.abdik.shiro.util.JVMWatchdog;
import com.abdik.shiro.util.ShiroLimiterConfig;
import com.abdik.shiro.util.ThreadLocalCleaner;
import com.abdik.shiro.vm.GCForcer;
import com.abdik.shiro.vm.low.AWTEventQueueCleaner;
import com.abdik.shiro.vm.low.AdvancedCleanupOps;
import com.abdik.shiro.vm.low.ClassloaderLeakBreaker;
import com.abdik.shiro.vm.low.FinalizerCleaner;
import com.abdik.shiro.vm.low.HiddenCleanupOps;
import com.abdik.shiro.vm.low.ObjectFieldZeroer;
import com.abdik.shiro.vm.low.OffHeapReferenceCleaner;
import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_310;

public class ShiroMod
implements ClientModInitializer {
    private static Thread watchdogThread;
    private static JVMWatchdog watchdog;
    public static volatile boolean running;
    public static ModConfig config;

    public void onInitializeClient() {
        AgentLoader.loadAgentIfRequired();
        config = ModConfig.load();
        ShiroRuntime.init();
        ShiroLimiterConfig.load();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            MemCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher);
            MemDevCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher);
        });
        MemoryOverlay.register();
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
            MemOps.fastZero(buffer, 4096);
            System.out.println("[ShiroMod] Native memory zero success!");
        }
        catch (Throwable t) {
            System.err.println("[ShiroMod] Native memory zero failed: " + t.getMessage());
        }
        if (ShiroMod.config.autoStartMemoryThread) {
            Thread memoryThread = new Thread(() -> {
                Runtime rt = Runtime.getRuntime();
                long lastMediumCleanup = System.currentTimeMillis();
                long lastHardCleanup = 0L;
                while (running) {
                    try {
                        long now = System.currentTimeMillis();
                        if (ShiroMod.config.enableMinimumCleanup) {
                            ShiroMod.minimumCleanup();
                        }
                        if (ShiroMod.config.enableMediumCleanup && now - lastMediumCleanup >= (long)ShiroMod.config.mediumCleanupIntervalMinutes * 60000L) {
                            ShiroMod.mediumCleanup();
                            OffHeapReferenceCleaner.cleanOrphaned();
                            ClassloaderLeakBreaker.breakLeaks();
                            lastMediumCleanup = now;
                        }
                        long used = rt.totalMemory() - rt.freeMemory();
                        long max = rt.maxMemory();
                        double usageRatio = (double)used / (double)max;
                        double threshold = ShiroMod.config.hardCleanupThreshold;
                        if (threshold > 0.9) {
                            threshold = 0.6;
                        }
                        if (ShiroMod.config.enableHardCleanup && usageRatio > threshold && now - lastHardCleanup >= ShiroMod.config.hardCleanupMinIntervalMillis) {
                            ShiroMod.hardCleanup();
                            lastHardCleanup = now;
                            Thread.sleep(20000L);
                            continue;
                        }
                        Thread.sleep(ShiroMod.config.minimumCleanupIntervalMillis);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception exception) {}
                }
            }, "Shiro-MemoryMonitor");
            memoryThread.setDaemon(true);
            memoryThread.start();
            watchdog = new JVMWatchdog(config);
            watchdogThread = new Thread((Runnable)watchdog, "JVMWatchdogThread");
            watchdogThread.setDaemon(true);
            watchdogThread.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                running = false;
            }));
        }
    }

    public static void notifyWatchdogActivity() {
        if (watchdog != null) {
            watchdog.notifyActivity();
        }
    }

    public static void minimumCleanup() {
        try {
            class_310 mc = class_310.method_1551();
            if (mc.field_1713 != null) {
                for (Field field : mc.field_1713.getClass().getDeclaredFields()) {
                    if (!List.class.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    Object list = field.get(mc.field_1713);
                    if (!(list instanceof List)) continue;
                    DeepNullifier.deepClearList((List)list);
                }
            }
            mc.method_1531().method_4622();
            try {
                ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
                MemOps.fastZero(buffer, 4096);
            }
            catch (Throwable throwable) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void mediumCleanup() {
        System.gc();
        GCForcer.forceGCHard();
    }

    public static void hardCleanup() {
        try {
            class_310 mc = class_310.method_1551();
            if (mc.method_1483() != null) {
                mc.method_1483().method_4881();
            }
            if (mc.field_1713 != null) {
                for (Field field : mc.field_1713.getClass().getDeclaredFields()) {
                    if (!List.class.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    Object list = field.get(mc.field_1713);
                    if (!(list instanceof List)) continue;
                    DeepNullifier.deepClearList((List)list);
                }
            }
            mc.method_1531().method_4622();
            Field chunkManagerField = null;
            for (Field field : mc.field_1769.getClass().getDeclaredFields()) {
                if (!field.getType().getSimpleName().equals("ChunkManager")) continue;
                chunkManagerField = field;
                break;
            }
            if (chunkManagerField != null) {
                chunkManagerField.setAccessible(true);
                Object chunkManager = chunkManagerField.get(mc.field_1769);
                if (chunkManager != null) {
                    for (Field subField : chunkManager.getClass().getDeclaredFields()) {
                        if (!Map.class.isAssignableFrom(subField.getType())) continue;
                        subField.setAccessible(true);
                        Map map = (Map)subField.get(chunkManager);
                        DeepNullifier.deepClearMap(map);
                        break;
                    }
                }
            }
            Field textRendererField = class_310.class.getDeclaredField("textRenderer");
            textRendererField.setAccessible(true);
            Object textRenderer = textRendererField.get(mc);
            if (textRenderer != null) {
                Field glyphCacheField = textRenderer.getClass().getDeclaredField("glyphCache");
                glyphCacheField.setAccessible(true);
                Object glyphCache = glyphCacheField.get(textRenderer);
                if (glyphCache instanceof Map) {
                    DeepNullifier.deepClearMap((Map)glyphCache);
                }
            }
            try {
                Field advancementHandlerField = class_310.class.getDeclaredField("advancementHandler");
                advancementHandlerField.setAccessible(true);
                Object advancementHandler = advancementHandlerField.get(mc);
                if (advancementHandler != null) {
                    Field advancementsField = advancementHandler.getClass().getDeclaredField("advancements");
                    advancementsField.setAccessible(true);
                    Object advancements = advancementsField.get(advancementHandler);
                    if (advancements instanceof Map) {
                        DeepNullifier.deepClearMap((Map)advancements);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException advancementHandlerField) {
                // empty catch block
            }
            ThreadLocalCleaner.clearCurrent();
            for (int i = 0; i < 3; ++i) {
                System.gc();
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                ByteBuffer dummy = ByteBuffer.allocateDirect(1);
                DirectBufferForceFree.forceFree(dummy);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            OffHeapReferenceCleaner.cleanOrphaned();
            ClassloaderLeakBreaker.breakLeaks();
            ObjectFieldZeroer.zeroLargeFields(ShiroRuntime.class);
            HiddenCleanupOps.runLowLevelCleanups();
            AdvancedCleanupOps.run();
            FinalizerCleaner.drainFinalizerQueue();
            AWTEventQueueCleaner.clean();
            LowLevelCleanupHook.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ShiroMod.notifyWatchdogActivity();
    }

    static {
        running = true;
    }
}

