/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.commands;

import com.abdik.shiro.MemoryOverlay;
import com.abdik.shiro.ModConfig;
import com.abdik.shiro.ShiroMod;
import com.abdik.shiro.vm.low.HeapShrinker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;

public class MemCommand {
    private static long lastCleanTime = 0L;
    private static final long COOLDOWN_MILLIS = 10000L;

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mem").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Mem Command Registered"));
            return 1;
        })).then(ClientCommandManager.literal((String)"clean").executes(MemCommand::executeClean))).then(ClientCommandManager.literal((String)"hud").executes(MemCommand::executeHudToggle)));
    }

    private static int executeClean(CommandContext<FabricClientCommandSource> context) {
        long now = System.currentTimeMillis();
        long timeSinceLast = now - lastCleanTime;
        if (timeSinceLast < 10000L) {
            long secondsLeft = (10000L - timeSinceLast) / 1000L;
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Please wait %d second%s before cleaning again.", secondsLeft <= 0L ? 1L : secondsLeft, secondsLeft == 1L ? "" : "s")));
            return 0;
        }
        lastCleanTime = now;
        Runtime runtime = Runtime.getRuntime();
        long totalMemBefore = runtime.totalMemory();
        long freeMemBefore = runtime.freeMemory();
        long usedMemBefore = totalMemBefore - freeMemBefore;
        long maxMem = runtime.maxMemory();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Memory Usage before cleanup: Used %.2f MB / Max %.2f MB.", (double)usedMemBefore / 1048576.0, (double)maxMem / 1048576.0)));
        ModConfig.load();
        ShiroMod.hardCleanup();
        HeapShrinker.shrinkHeap();
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        long totalMemAfter = runtime.totalMemory();
        long freeMemAfter = runtime.freeMemory();
        long usedMemAfter = totalMemAfter - freeMemAfter;
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Memory Usage after cleanup: Used %.2f MB / Max %.2f MB.", (double)usedMemAfter / 1048576.0, (double)maxMem / 1048576.0)));
        double freedMB = (double)(usedMemBefore - usedMemAfter) / 1048576.0;
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Memory reclaimed: %.2f MB", freedMB)));
        return 1;
    }

    private static int executeHudToggle(CommandContext<FabricClientCommandSource> context) {
        MemoryOverlay.ENABLED = !MemoryOverlay.ENABLED;
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Memory HUD " + (MemoryOverlay.ENABLED ? "enabled" : "disabled"))));
        return 1;
    }
}

