/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.vm.low;

import com.abdik.shiro.vm.low.AnonymousClassUnloader;
import com.abdik.shiro.vm.low.CleanerQueueDrainer;
import com.abdik.shiro.vm.low.LambdaCleaner;
import com.abdik.shiro.vm.low.MBeanUnregistrar;
import com.abdik.shiro.vm.low.NIOIdleChannelCleaner;
import com.abdik.shiro.vm.low.ThreadAuditor;
import com.abdik.shiro.vm.low.ZipFileLeakCleaner;
import java.beans.Introspector;
import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;

public final class AdvancedCleanupOps {
    public static void run() {
        AdvancedCleanupOps.runSafe(AdvancedCleanupOps::purgeWeakReferences);
        AdvancedCleanupOps.runSafe(AdvancedCleanupOps::cleanLambdaCaches);
        AdvancedCleanupOps.runSafe(AdvancedCleanupOps::fixMetadataLeaks);
        AdvancedCleanupOps.runSafe(CleanerQueueDrainer::drain);
        AdvancedCleanupOps.runSafe(ZipFileLeakCleaner::closeOpenZipFiles);
        AdvancedCleanupOps.runSafe(ThreadAuditor::auditThreads);
        AdvancedCleanupOps.runSafe(NIOIdleChannelCleaner::closeIdleSelectors);
        AdvancedCleanupOps.runSafe(MBeanUnregistrar::unregisterCustomMBeans);
        AdvancedCleanupOps.runSafe(LambdaCleaner::run);
        AdvancedCleanupOps.runSafe(AnonymousClassUnloader::run);
    }

    private static void runSafe(SafeRunnable action) {
        try {
            action.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void purgeWeakReferences() {
        System.gc();
        try {
            Field queueField = Reference.class.getDeclaredField("queue");
            queueField.setAccessible(true);
            List<SoftReference<Object>> refs = List.of(new WeakReference<Object>(new Object()), new SoftReference<Object>(new Object()));
            for (Reference reference : refs) {
                Reference polled;
                Object queue = queueField.get(reference);
                if (!(queue instanceof ReferenceQueue)) continue;
                ReferenceQueue refQueue = (ReferenceQueue)queue;
                while ((polled = refQueue.poll()) != null) {
                    polled.clear();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void cleanLambdaCaches() {
        try {
            Class<?> lambdaMetaFactory = Class.forName("java.lang.invoke.InnerClassLambdaMetafactory");
            for (Field f : lambdaMetaFactory.getDeclaredFields()) {
                if (!Modifier.isStatic(f.getModifiers())) continue;
                f.setAccessible(true);
                Object val = f.get(null);
                if (!(val instanceof Map)) continue;
                Map map = (Map)val;
                map.clear();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void fixMetadataLeaks() {
        AdvancedCleanupOps.runSafe(Introspector::flushCaches);
        AdvancedCleanupOps.runSafe(() -> {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Field classField = MethodHandles.Lookup.class.getDeclaredField("lookupClass");
            classField.setAccessible(true);
            classField.set(lookup, Object.class);
        });
    }

    @FunctionalInterface
    private static interface SafeRunnable {
        public void run() throws Exception;
    }
}

