/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.agent;

import com.abdik.shiro.agent.AgentBootstrap;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.WeakHashMap;

public class DirectBufferCleanerTransformer
implements ClassFileTransformer {
    private static volatile boolean started = false;
    private static final WeakHashMap<ByteBuffer, Boolean> tracked = new WeakHashMap();
    private static final long SCAN_INTERVAL_MS = 120000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] transform(Module module, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] classfileBuffer) {
        if (started || !"java/nio/DirectByteBuffer".equals(className)) return null;
        Class<DirectBufferCleanerTransformer> clazz = DirectBufferCleanerTransformer.class;
        synchronized (DirectBufferCleanerTransformer.class) {
            if (started) return null;
            started = true;
            DirectBufferCleanerTransformer.startCleanerThread();
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return null;
        }
    }

    private static void startCleanerThread() {
        Thread t = new Thread(() -> {
            while (true) {
                try {
                    Instrumentation inst = AgentBootstrap.INSTRUMENTATION;
                    if (inst != null) {
                        Class[] loaded = inst.getAllLoadedClasses();
                        for (Class cls : loaded) {
                            try {
                                Field[] fields;
                                if (cls.getName() == null || !cls.getName().startsWith("com.abdik.shiro")) continue;
                                for (Field f : fields = cls.getDeclaredFields()) {
                                    try {
                                        ByteBuffer bb;
                                        if (!ByteBuffer.class.isAssignableFrom(f.getType())) continue;
                                        f.setAccessible(true);
                                        Object v = f.get(null);
                                        if (!(v instanceof ByteBuffer) || !(bb = (ByteBuffer)v).isDirect()) continue;
                                        try {
                                            DirectBufferCleanerTransformer.cleanDirectByteBuffer(bb);
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        // empty catch block
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    WeakHashMap<ByteBuffer, Boolean> weakHashMap = tracked;
                    synchronized (weakHashMap) {
                        for (ByteBuffer b : tracked.keySet().toArray(new ByteBuffer[0])) {
                            try {
                                if (b == null || !b.isDirect()) continue;
                                DirectBufferCleanerTransformer.cleanDirectByteBuffer(b);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Throwable inst) {
                    // empty catch block
                }
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }, "Shiro-DirectBuffer-Cleaner");
        t.setDaemon(true);
        t.start();
    }

    public static void cleanDirectByteBuffer(ByteBuffer buffer) {
        Object cleaner;
        if (buffer == null) {
            return;
        }
        if (!buffer.isDirect()) {
            return;
        }
        try {
            Method cleanerMethod = null;
            try {
                cleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (cleanerMethod != null) {
                cleanerMethod.setAccessible(true);
                cleaner = cleanerMethod.invoke((Object)buffer, new Object[0]);
                if (cleaner != null) {
                    Method clean = cleaner.getClass().getMethod("clean", new Class[0]);
                    clean.setAccessible(true);
                    clean.invoke(cleaner, new Object[0]);
                    return;
                }
            }
        }
        catch (Throwable cleanerMethod) {
            // empty catch block
        }
        try {
            Field f = buffer.getClass().getDeclaredField("cleaner");
            f.setAccessible(true);
            cleaner = f.get(buffer);
            if (cleaner != null) {
                Method clean = cleaner.getClass().getMethod("clean", new Class[0]);
                clean.setAccessible(true);
                clean.invoke(cleaner, new Object[0]);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void track(ByteBuffer buf) {
        if (buf == null) {
            return;
        }
        WeakHashMap<ByteBuffer, Boolean> weakHashMap = tracked;
        synchronized (weakHashMap) {
            tracked.put(buf, Boolean.TRUE);
        }
    }
}

