/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;
import java.util.Set;

public class ThreadLocalCleanerTransformer
implements ClassFileTransformer {
    private static volatile boolean started = false;
    private static final long CLEAN_INTERVAL_MS = 60000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] transform(Module module, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] classfileBuffer) {
        if (started || !"java/lang/Thread".equals(className)) return null;
        Class<ThreadLocalCleanerTransformer> clazz = ThreadLocalCleanerTransformer.class;
        synchronized (ThreadLocalCleanerTransformer.class) {
            if (started) return null;
            started = true;
            ThreadLocalCleanerTransformer.startCleanerThread();
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return null;
        }
    }

    private static void startCleanerThread() {
        Thread t = new Thread(() -> {
            Field threadLocalsField = null;
            Field inheritableThreadLocalsField = null;
            try {
                threadLocalsField = Thread.class.getDeclaredField("threadLocals");
                threadLocalsField.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                inheritableThreadLocalsField = Thread.class.getDeclaredField("inheritableThreadLocals");
                inheritableThreadLocalsField.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            while (true) {
                try {
                    Set<Thread> threads = Thread.getAllStackTraces().keySet();
                    for (Thread thr : threads) {
                        try {
                            if (thr.getState() != Thread.State.TERMINATED) continue;
                            if (threadLocalsField != null) {
                                try {
                                    Object tl = threadLocalsField.get(thr);
                                    if (tl != null) {
                                        threadLocalsField.set(thr, null);
                                    }
                                }
                                catch (IllegalAccessException tl) {
                                    // empty catch block
                                }
                            }
                            if (inheritableThreadLocalsField == null) continue;
                            try {
                                Object itl = inheritableThreadLocalsField.get(thr);
                                if (itl == null) continue;
                                inheritableThreadLocalsField.set(thr, null);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable threads) {
                    // empty catch block
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }, "Shiro-ThreadLocal-Cleaner");
        t.setDaemon(true);
        t.start();
    }
}

