/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.cpu;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.IOException;
import java.lang.management.ManagementFactory;

public class AffinityManager {
    public static void pinCurrentThreadToCpu(int cpuCoreId) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            AffinityManager.pinWindows(cpuCoreId);
        } else if (os.contains("nix") || os.contains("nux") || os.contains("mac")) {
            AffinityManager.pinLinux(cpuCoreId);
        } else {
            System.out.println("[AffinityManager] Unsupported OS for CPU affinity.");
        }
    }

    private static void pinWindows(int cpuCoreId) {
        try {
            Kernel32Extended kernel32 = (Kernel32Extended)Native.load((String)"kernel32", Kernel32Extended.class);
            WinNT.HANDLE hThread = Kernel32.INSTANCE.GetCurrentThread();
            int affinityMask = 1 << cpuCoreId;
            if (kernel32.SetThreadAffinityMask(hThread, affinityMask)) {
                System.out.println("[AffinityManager] Successfully pinned to CPU core: " + cpuCoreId);
            } else {
                System.err.println("[AffinityManager] Failed to set thread affinity on Windows.");
            }
        }
        catch (Exception e) {
            System.err.println("[AffinityManager] Error pinning thread on Windows: " + e.getMessage());
        }
    }

    private static void pinLinux(int cpuCoreId) {
        try {
            String command = String.format("taskset -c %d %s", cpuCoreId, AffinityManager.getProcessID());
            Runtime.getRuntime().exec(command);
            System.out.println("[AffinityManager] Successfully pinned to CPU core: " + cpuCoreId);
        }
        catch (IOException e) {
            System.err.println("[AffinityManager] Error pinning thread on Linux: " + e.getMessage());
        }
    }

    private static String getProcessID() {
        String processID = "";
        try {
            processID = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processID;
    }

    public static interface Kernel32Extended
    extends Kernel32 {
        public boolean SetThreadAffinityMask(WinNT.HANDLE var1, int var2);
    }
}

