/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.cpu;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class HotLoopDetector {
    public static void logHotThreads() {
        long[] threadIds;
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        if (!bean.isThreadCpuTimeSupported() || !bean.isThreadCpuTimeEnabled()) {
            return;
        }
        for (long id : threadIds = bean.getAllThreadIds()) {
            long cpuTime = bean.getThreadCpuTime(id);
            if (cpuTime <= 100000000L) continue;
            String threadName = HotLoopDetector.findThreadNameById(id);
            System.out.println("[HotLoopDetector] High CPU usage thread: " + threadName + " (id=" + id + "), time=" + cpuTime + "ns");
        }
    }

    private static String findThreadNameById(long id) {
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (thread.getId() != id) continue;
            return thread.getName();
        }
        return "unknown";
    }
}

