/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.gpu;

import com.abdik.shiro.gpu.GPUVendor;
import com.abdik.shiro.natives.NativeLoader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class GPUInfo {
    private static final ScheduledExecutorService SCHED = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "Shiro-GPUInfo");
        t.setDaemon(true);
        return t;
    });
    private static volatile boolean initialized = false;
    private static volatile String gpuModel = "Unknown GPU Model";
    private static volatile GPUVendor cachedVendor = GPUVendor.UNKNOWN;
    private static final AtomicInteger cachedMemoryMB = new AtomicInteger(-1);
    private static final AtomicInteger cachedUtilization = new AtomicInteger(-1);
    private static volatile long lastUpdateMs = 0L;
    private static final long POLL_INTERVAL_MS = 1000L;

    private static void initGpuInfoAsync() {
        if (initialized) {
            return;
        }
        initialized = true;
        CompletableFuture.runAsync(() -> {
            try {
                cachedVendor = GPUVendor.fromCode(GPUInfo.nativeGetVendor());
            }
            catch (Throwable t) {
                cachedVendor = GPUVendor.UNKNOWN;
            }
            try {
                switch (cachedVendor) {
                    case NVIDIA: {
                        gpuModel = GPUInfo.execSingleLine("nvidia-smi --query-gpu=name --format=csv,noheader");
                        break;
                    }
                    case AMD: {
                        gpuModel = GPUInfo.execSingleLine("rocm-smi --showproductname -d 0");
                        break;
                    }
                    case INTEL: {
                        gpuModel = GPUInfo.execSingleLine("bash -lc \"lspci | grep -i 'intel.*vga' | head -n1\"");
                        break;
                    }
                    default: {
                        gpuModel = "Unknown GPU Model";
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (gpuModel == null || gpuModel.isBlank()) {
                gpuModel = "Unknown GPU Model";
            }
            System.out.println("[GPUInfo] Detected vendor: " + String.valueOf((Object)cachedVendor));
            System.out.println("[GPUInfo] GPU Model: " + gpuModel);
        });
    }

    private static String execSingleLine(String cmd) {
        String string;
        Process p = Runtime.getRuntime().exec(new String[]{"bash", "-lc", cmd});
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String line = r.readLine();
            p.waitFor(500L, TimeUnit.MILLISECONDS);
            string = line == null ? "" : line.trim();
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                return "";
            }
        }
        r.close();
        return string;
    }

    private static void pollNativeStats() {
        long now = System.currentTimeMillis();
        if (now - lastUpdateMs < 1000L) {
            return;
        }
        lastUpdateMs = now;
        try {
            int mem = GPUInfo.nativeMemoryMB();
            int util = GPUInfo.nativeUtilization();
            if (mem >= 0) {
                cachedMemoryMB.set(mem);
            }
            if (util >= 0) {
                cachedUtilization.set(util);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int getMemoryMB() {
        int mem = cachedMemoryMB.get();
        return mem >= 0 ? mem : 0;
    }

    public static int getUtilization() {
        int util = cachedUtilization.get();
        return util >= 0 ? util : 0;
    }

    public static GPUVendor getVendor() {
        return cachedVendor;
    }

    public static String getModel() {
        return gpuModel;
    }

    public static void debugNativeStats() {
        try {
            System.out.println("[GPUInfo] Vendor code: " + GPUInfo.nativeGetVendor());
            System.out.println("[GPUInfo] Utilization: " + GPUInfo.nativeUtilization());
            System.out.println("[GPUInfo] Memory MB: " + GPUInfo.nativeMemoryMB());
        }
        catch (Throwable t) {
            System.err.println("[GPUInfo] Native call failed: " + t.getMessage());
        }
    }

    public static native int nativeMemoryMB();

    public static native int nativeUtilization();

    public static native int nativeGetVendor();

    public static void logBasicInfo() {
        System.out.println("[GPUInfo] Vendor: " + String.valueOf((Object)GPUInfo.getVendor()));
        System.out.println("[GPUInfo] Model: " + GPUInfo.getModel());
        System.out.println("[GPUInfo] MemoryMB: " + GPUInfo.getMemoryMB());
        System.out.println("[GPUInfo] Util%: " + GPUInfo.getUtilization());
    }

    static {
        try {
            NativeLoader.load();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        GPUInfo.initGpuInfoAsync();
        SCHED.scheduleAtFixedRate(GPUInfo::pollNativeStats, 1L, 1L, TimeUnit.SECONDS);
    }
}

