/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.hooks;

import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public final class LowLevelCleanupHook {
    private LowLevelCleanupHook() {
    }

    public static void run() {
        try {
            LowLevelCleanupHook.drainReferenceQueues();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            LowLevelCleanupHook.clearEnumCaches();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            LowLevelCleanupHook.patchLookupLeak();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            LowLevelCleanupHook.cleanupThreadGroups();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void drainReferenceQueues() {
        Reference ref;
        System.gc();
        ReferenceQueue rq = new ReferenceQueue();
        new WeakReference<Object>(new Object(), rq);
        new SoftReference<Object>(new Object(), rq);
        while ((ref = rq.poll()) != null) {
            ref.clear();
        }
    }

    private static void clearEnumCaches() {
        try {
            Field enumConstantDirectory = Class.class.getDeclaredField("enumConstantDirectory");
            Field enumConstants = Class.class.getDeclaredField("enumConstants");
            enumConstantDirectory.setAccessible(true);
            enumConstants.setAccessible(true);
            ClassLoader system = ClassLoader.getSystemClassLoader();
            Set visited = Collections.newSetFromMap(new WeakHashMap());
            for (Package pkg : Package.getPackages()) {
                if (!pkg.getName().startsWith("com.abdik.shiro")) continue;
                try {
                    Class<?> cls = system.loadClass(pkg.getName());
                    if (visited.contains(cls) || !cls.isEnum()) continue;
                    visited.add(cls);
                    enumConstantDirectory.set(cls, null);
                    enumConstants.set(cls, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void patchLookupLeak() {
        try {
            MethodHandles.lookup().dropLookupMode(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void cleanupThreadGroups() {
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        LowLevelCleanupHook.pruneGroupRecursive(root);
    }

    private static void pruneGroupRecursive(ThreadGroup group) {
        ThreadGroup[] subs = new ThreadGroup[group.activeGroupCount() * 2 + 1];
        int count = group.enumerate(subs, false);
        for (int i = 0; i < count; ++i) {
            ThreadGroup sub = subs[i];
            if (sub == null) continue;
            LowLevelCleanupHook.pruneGroupRecursive(sub);
            if (sub.activeCount() != 0 || sub.activeGroupCount() != 0 || sub == Thread.currentThread().getThreadGroup()) continue;
            try {
                sub.destroy();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

