/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.mixin;

import com.abdik.shiro.security.ShiroSecurity;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Socket.class}, remap=false)
public class MixinSocket {
    @Inject(method={"connect(Ljava/net/SocketAddress;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onConnect(SocketAddress endpoint, int timeout, CallbackInfo ci) {
        try {
            InetSocketAddress inet;
            if (endpoint instanceof InetSocketAddress && !ShiroSecurity.isAllowedSocket(inet = (InetSocketAddress)endpoint)) {
                ci.cancel();
                System.err.println("[Shiro] Blocked Socket.connect() to: " + String.valueOf(inet));
                throw new SecurityException("Connection blocked by ShiroSecurity policy.");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

