/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.network;

import com.abdik.shiro.network.SocketOptionsTuner;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;

public class NetworkStatsMonitor {
    private static final AtomicInteger openSockets = new AtomicInteger();
    private static final AtomicInteger totalDataSent = new AtomicInteger();
    private static final AtomicInteger totalDataReceived = new AtomicInteger();

    public static void init() {
        System.out.println("[Shiro] NetworkStatsMonitor started.");
    }

    public static void socketOpened(Socket s) {
        openSockets.incrementAndGet();
        SocketOptionsTuner.apply(s);
    }

    public static void socketClosed(Socket s) {
        int v = openSockets.decrementAndGet();
        if (v < 0) {
            openSockets.set(0);
        }
    }

    public static int getOpenSocketCount() {
        return openSockets.get();
    }

    public static void trackSentBytes(int bytes) {
        totalDataSent.addAndGet(bytes);
    }

    public static void trackReceivedBytes(int bytes) {
        totalDataReceived.addAndGet(bytes);
    }

    public static double getNetworkActivity() {
        int count = NetworkStatsMonitor.getOpenSocketCount();
        double normalized = Math.min((double)count / 50.0, 1.0);
        return normalized;
    }

    public static int getSentBytes() {
        return totalDataSent.get();
    }

    public static int getReceivedBytes() {
        return totalDataReceived.get();
    }
}

