/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.network;

import com.abdik.shiro.network.NetworkStatsMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;

public class ShiroSocket
extends Socket {
    private volatile boolean openedTracked = false;

    public ShiroSocket() throws IOException {
        NetworkStatsMonitor.socketOpened(this);
    }

    public ShiroSocket(String host, int port) throws IOException {
        super(host, port);
        NetworkStatsMonitor.socketOpened(this);
    }

    public ShiroSocket(InetAddress address, int port) throws IOException {
        super(address, port);
        NetworkStatsMonitor.socketOpened(this);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        super.connect(endpoint);
        this.markOpened();
    }

    private void markOpened() {
        if (!this.openedTracked) {
            NetworkStatsMonitor.socketOpened(this);
            this.openedTracked = true;
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        super.connect(endpoint, timeout);
        NetworkStatsMonitor.socketOpened(this);
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        NetworkStatsMonitor.socketClosed(this);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new CountingInputStream(super.getInputStream());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new CountingOutputStream(super.getOutputStream());
    }

    private static class CountingInputStream
    extends InputStream {
        private final InputStream in;

        CountingInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b != -1) {
                NetworkStatsMonitor.trackReceivedBytes(1);
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int count = this.in.read(b, off, len);
            if (count > 0) {
                NetworkStatsMonitor.trackReceivedBytes(count);
            }
            return count;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int count = this.in.read(b);
            if (count > 0) {
                NetworkStatsMonitor.trackReceivedBytes(count);
            }
            return count;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    private static class CountingOutputStream
    extends OutputStream {
        private final OutputStream out;

        CountingOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            NetworkStatsMonitor.trackSentBytes(1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            NetworkStatsMonitor.trackSentBytes(len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
            NetworkStatsMonitor.trackSentBytes(b.length);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

