/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.network;

import com.abdik.shiro.network.SocketOptionsTuner;
import com.abdik.shiro.network.WrappedSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SilentSocketPool {
    private static final int MAX_POOL_SIZE = 50;
    private static final ConcurrentLinkedQueue<WrappedSocket> pool = new ConcurrentLinkedQueue();

    public static WrappedSocket acquire(String host, int port) throws IOException {
        for (int attempt = 0; attempt < 5; ++attempt) {
            WrappedSocket socket = pool.poll();
            if (socket == null) {
                WrappedSocket fresh = new WrappedSocket(host, port);
                SocketOptionsTuner.apply(fresh);
                return fresh;
            }
            if (socket.isClosed() || !socket.isConnected() || socket.isInputShutdown() || socket.isOutputShutdown()) {
                SilentSocketPool.closeQuietly(socket);
                continue;
            }
            if (!socket.isConnected()) {
                try {
                    socket.connect(new InetSocketAddress(host, port));
                }
                catch (IOException e) {
                    SilentSocketPool.closeQuietly(socket);
                    continue;
                }
            }
            SocketOptionsTuner.apply(socket);
            return socket;
        }
        WrappedSocket fresh = new WrappedSocket(host, port);
        SocketOptionsTuner.apply(fresh);
        return fresh;
    }

    public static void release(WrappedSocket socket) {
        if (socket == null) {
            return;
        }
        if (socket.isClosed() || !socket.isConnected() || socket.isInputShutdown() || socket.isOutputShutdown()) {
            SilentSocketPool.closeQuietly(socket);
            return;
        }
        if (pool.size() >= 50) {
            SilentSocketPool.closeQuietly(socket);
            return;
        }
        SocketOptionsTuner.apply(socket);
        pool.offer(socket);
    }

    public static void clear() {
        WrappedSocket socket;
        while ((socket = pool.poll()) != null) {
            SilentSocketPool.closeQuietly(socket);
        }
    }

    public static int size() {
        return pool.size();
    }

    private static void closeQuietly(WrappedSocket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

