/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.os;

import com.abdik.shiro.natives.NativeLoader;
import com.abdik.shiro.os.SchedulerPolicy;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ThreadAffinityController {
    private static final Logger LOG = Logger.getLogger("com.abdik.shiro.os.ThreadAffinityController");
    private static volatile boolean nativeAvailable;
    private static volatile boolean checkedNative;

    private ThreadAffinityController() {
    }

    private static native boolean nativeSetCurrentThreadAffinity(long var0);

    private static native boolean nativeSetCurrentThreadScheduling(int var0, int var1);

    private static synchronized void ensureNativeAvailability() {
        if (checkedNative) {
            return;
        }
        checkedNative = true;
        try {
            nativeAvailable = ThreadAffinityController.nativeSetCurrentThreadAffinity(0L);
        }
        catch (NoSuchMethodError | UnsatisfiedLinkError e) {
            nativeAvailable = false;
            LOG.log(Level.FINE, "Affinity native methods not present: " + e.getMessage());
        }
        catch (Throwable e) {
            nativeAvailable = false;
            LOG.log(Level.WARNING, "Affinity native probe failed: " + e.getMessage(), e);
        }
    }

    public static boolean setCurrentThreadAffinity(long cpuMask) {
        ThreadAffinityController.ensureNativeAvailability();
        if (!nativeAvailable) {
            return false;
        }
        try {
            return ThreadAffinityController.nativeSetCurrentThreadAffinity(cpuMask);
        }
        catch (Throwable e) {
            nativeAvailable = false;
            LOG.log(Level.WARNING, "Failed to set thread affinity: " + e.getMessage(), e);
            return false;
        }
    }

    public static boolean setCurrentThreadScheduling(SchedulerPolicy policy, int priority) {
        Objects.requireNonNull(policy);
        ThreadAffinityController.ensureNativeAvailability();
        if (!nativeAvailable) {
            return false;
        }
        try {
            return ThreadAffinityController.nativeSetCurrentThreadScheduling(policy.getPolicy(), priority);
        }
        catch (Throwable e) {
            nativeAvailable = false;
            LOG.log(Level.WARNING, "Failed to set thread scheduling: " + e.getMessage(), e);
            return false;
        }
    }

    public static long cpuMaskFor(int cpuIndex) {
        if (cpuIndex < 0 || cpuIndex >= 64) {
            throw new IllegalArgumentException("cpuIndex out of range: " + cpuIndex);
        }
        return 1L << cpuIndex;
    }

    public static ThreadFactory affinitizedFactory(long cpuMask, SchedulerPolicy policy, int priority, String namePrefix) {
        return new AffinitizedThreadFactory(cpuMask, policy, priority, namePrefix);
    }

    static {
        try {
            NativeLoader.load();
            LOG.fine("NativeLoader invoked for ThreadAffinityController.");
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, "Native loader not available at startup: " + t.getMessage());
        }
        nativeAvailable = false;
        checkedNative = false;
    }

    private static class AffinitizedThreadFactory
    implements ThreadFactory {
        private final long cpuMask;
        private final SchedulerPolicy policy;
        private final int priority;
        private final String namePrefix;
        private int counter = 0;

        AffinitizedThreadFactory(long cpuMask, SchedulerPolicy policy, int priority, String namePrefix) {
            this.cpuMask = cpuMask;
            this.policy = policy;
            this.priority = priority;
            this.namePrefix = namePrefix == null || namePrefix.isEmpty() ? "shiro-thread" : namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.namePrefix + "-" + ++this.counter;
            Runnable wrapper = () -> {
                try {
                    if (this.cpuMask != 0L) {
                        ThreadAffinityController.setCurrentThreadAffinity(this.cpuMask);
                    }
                    if (this.policy != null) {
                        ThreadAffinityController.setCurrentThreadScheduling(this.policy, this.priority);
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.FINE, "Affinity/scheduling failed for " + name + ": " + t.getMessage());
                }
                r.run();
            };
            Thread t = new Thread(wrapper, name);
            t.setDaemon(false);
            t.setUncaughtExceptionHandler(this.defaultHandler());
            return t;
        }

        private Thread.UncaughtExceptionHandler defaultHandler() {
            return (th, ex) -> LOG.log(Level.SEVERE, "Uncaught in " + th.getName(), ex);
        }
    }
}

