/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.os;

import com.abdik.shiro.natives.NativeLoader;

public class ThreadStackManager {
    public static final long MIN_STACK_SIZE = 131072L;
    public static final long MAX_STACK_SIZE = 0x400000L;

    private static native long nativeCreateThreadWithStack(Runnable var0, long var1);

    private static native long nativeGetCurrentThreadStackSize();

    public static long createThreadWithStack(Runnable runnable, long stackSize) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        long size = Math.max(131072L, Math.min(0x400000L, stackSize));
        try {
            long nativeResult = ThreadStackManager.nativeCreateThreadWithStack(runnable, size);
            if (nativeResult > 0L) {
                return nativeResult;
            }
        }
        catch (NoSuchMethodError | UnsatisfiedLinkError nativeResult) {
        }
        catch (Throwable t) {
            System.err.println("[ThreadStackManager] native createThreadWithStack failed: " + String.valueOf(t));
        }
        try {
            Thread t = new Thread(null, runnable, "shiro-stack-thread", size);
            t.setDaemon(false);
            t.start();
            return t.getId();
        }
        catch (Throwable t) {
            System.err.println("[ThreadStackManager] fallback createThreadWithStack failed: " + String.valueOf(t));
            return -1L;
        }
    }

    public static long getCurrentThreadStackSize() {
        try {
            return ThreadStackManager.nativeGetCurrentThreadStackSize();
        }
        catch (NoSuchMethodError | UnsatisfiedLinkError ignored) {
            return -1L;
        }
        catch (Throwable t) {
            System.err.println("[ThreadStackManager] native getCurrentThreadStackSize failed: " + String.valueOf(t));
            return -1L;
        }
    }

    static {
        try {
            NativeLoader.load();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

