/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.os.low;

import com.abdik.shiro.natives.NativeLoader;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public final class LowLevelCoreBooster
implements Runnable {
    private static native void ignite();

    @Override
    public void run() {
        if (!LowLevelCoreBooster.isPrivilegedEnvironment()) {
            System.out.println("[Shiro-Low] Skipping low-level optimizations (no privilege).");
            return;
        }
        try {
            LowLevelCoreBooster.ignite();
        }
        catch (Throwable t) {
            System.err.println("[Shiro-Low] Native booster failed: " + String.valueOf(t));
        }
    }

    public static void init() {
        Thread booster = new Thread((Runnable)new LowLevelCoreBooster(), "Shiro-Low-Booster");
        booster.setDaemon(true);
        booster.setPriority(10);
        booster.start();
    }

    private static boolean isPrivilegedEnvironment() {
        try {
            String env = System.getenv("SHIRO_DEV_MODE");
            if ("1".equals(env) || "true".equalsIgnoreCase(env)) {
                return true;
            }
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("win")) {
                Process p = Runtime.getRuntime().exec("net session");
                p.waitFor();
                return p.exitValue() == 0;
            }
            Process p = Runtime.getRuntime().exec("id -u");
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String uid = br.readLine();
            return "0".equals(uid);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    static {
        try {
            NativeLoader.load();
            System.out.println("[Shiro-Low] Native library loaded.");
        }
        catch (Throwable t) {
            System.err.println("[Shiro-Low] Failed to load native library: " + String.valueOf(t));
        }
    }
}

