/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.overlay;

import com.abdik.shiro.network.NetworkStatsMonitor;
import com.abdik.shiro.security.ShiroSecurity;
import java.awt.Color;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class NetworkOverlay {
    public static boolean ENABLED = false;
    private static final int GRAPH_WIDTH = 100;
    private static final int GRAPH_HEIGHT = 30;
    private static final int[] netHistory = new int[100];
    private static int updateTick = 0;

    public static void register() {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> NetworkOverlay.render(drawContext));
    }

    private static void render(class_332 context) {
        if (!ENABLED) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_327 tr = mc.field_1772;
        int x = 4;
        int y = 110;
        double netActivity = NetworkStatsMonitor.getNetworkActivity();
        double usagePercent = netActivity * 100.0;
        String statusText = ShiroSecurity.isFirewallActive() ? "ShiroSecurity: Active" : "ShiroSecurity: Disabled";
        int color = NetworkOverlay.getGradientColor(usagePercent);
        context.method_51439(tr, (class_2561)class_2561.method_43470((String)statusText), x + 1, y + 1, -16777216, false);
        context.method_51439(tr, (class_2561)class_2561.method_43470((String)statusText), x, y, color, false);
        if (updateTick++ % 10 == 0) {
            System.arraycopy(netHistory, 1, netHistory, 0, 99);
            NetworkOverlay.netHistory[99] = (int)(netActivity * 30.0);
        }
        int graphX = x;
        int graphY = y + 12;
        for (int i = 0; i < 100; ++i) {
            int barHeight = netHistory[i];
            int barColor = NetworkOverlay.getGradientColor((float)barHeight / 30.0f * 100.0f);
            context.method_25294(graphX + i, graphY + 30 - barHeight, graphX + i + 1, graphY + 30, barColor);
        }
    }

    private static int getGradientColor(double percent) {
        percent = Math.max(0.0, Math.min(percent, 100.0));
        float hueStart = 0.5833333f;
        float hueEnd = 0.5f;
        float hue = (float)((double)hueStart + (double)(hueEnd - hueStart) * (percent / 100.0));
        Color color = Color.getHSBColor(hue, 0.65f, 1.0f);
        return 0xFF000000 | color.getRGB() & 0xFFFFFF;
    }
}

