/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.security;

import com.abdik.shiro.security.PopupWarning;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.ReflectPermission;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.Permission;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import net.minecraft.class_310;

public final class ShiroSecurity {
    private static String runtimeJarHash;
    private static UserNotifier notifier;

    public static void init(Path jarPath, boolean strictMode, UserNotifier userNotifier) {
        System.out.println("[Shiro] Initializing ShiroSecurity (strict=" + strictMode + ")");
        EnhancedNetworkSecurity.denyAllPortsExcept(25565, 443, 80);
        EnhancedNetworkSecurity.allowCIDR("127.0.0.0/8");
        EnhancedNetworkSecurity.allowHostRegex("localhost|127\\.0\\.0\\.1");
        if (strictMode) {
            IntegrityChecker.verifyJar(jarPath);
        }
        try {
            System.setSecurityManager(new HardenedSecurityManager());
            System.out.println("[Shiro] HardenedSecurityManager active.");
        }
        catch (Throwable e) {
            System.err.println("[Shiro] SecurityManager not applied: " + String.valueOf(e));
        }
        RuntimeWatchdog.start();
        ShiroSecurity.enableRuntimeSelfCheck(jarPath, userNotifier);
    }

    public static boolean isAllowedSocket(InetSocketAddress addr) {
        return EnhancedNetworkSecurity.isAllowed(addr);
    }

    public static boolean isFirewallActive() {
        return EnhancedNetworkSecurity.isFirewallActive();
    }

    private static void enableRuntimeSelfCheck(Path jarPath, UserNotifier userNotifier) {
        notifier = userNotifier;
        runtimeJarHash = IntegrityChecker.computeSelfHash();
        System.out.println("[Shiro][Integrity] Initial hash recorded: " + runtimeJarHash);
        Thread t = new Thread(() -> {
            while (true) {
                Object alert;
                try {
                    while (true) {
                        String currentHash;
                        if (!runtimeJarHash.equals(currentHash = IntegrityChecker.computeSelfHash())) {
                            alert = "[Shiro] ALERT! Your game modified during runtime! Be aware";
                            System.err.println((String)alert);
                            EnhancedNetworkSecurity.blockAll();
                            PopupWarning.showAlert((String)alert);
                            if (notifier != null) {
                                try {
                                    class_310.method_1551().execute(() -> ShiroSecurity.lambda$enableRuntimeSelfCheck$0((String)alert));
                                }
                                catch (Throwable fallback) {
                                    try {
                                        notifier.notifyUser((String)alert);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                            }
                            return;
                        }
                        Thread.sleep(10000L);
                    }
                }
                catch (Throwable e) {
                    alert = "[Shiro][Integrity] Self-check error: " + String.valueOf(e);
                    System.err.println((String)alert);
                    if (notifier == null) continue;
                    try {
                        notifier.notifyUser((String)alert);
                    }
                    catch (Throwable throwable) {
                    }
                    continue;
                }
                break;
            }
        }, "Shiro-Integrity-Watchdog");
        t.setDaemon(true);
        t.start();
    }

    private ShiroSecurity() {
    }

    private static /* synthetic */ void lambda$enableRuntimeSelfCheck$0(String alert) {
        try {
            notifier.notifyUser(alert);
        }
        catch (Throwable ex) {
            System.err.println("[Shiro][Integrity] Notifier error: " + String.valueOf(ex));
        }
    }

    private static final class EnhancedNetworkSecurity {
        private static final Set<Integer> allowedPorts = Collections.synchronizedSet(new HashSet());
        private static final List<Subnet> allowedSubnets = new CopyOnWriteArrayList<Subnet>();
        private static final List<Pattern> allowedHostPatterns = new CopyOnWriteArrayList<Pattern>();
        private static volatile boolean firewallActive = true;
        private static final SecureRandom rng = new SecureRandom();

        private EnhancedNetworkSecurity() {
        }

        static void allowPort(int port) {
            allowedPorts.add(port);
        }

        static void denyAllPortsExcept(int ... ports) {
            allowedPorts.clear();
            for (int p : ports) {
                allowedPorts.add(p);
            }
        }

        static void allowHostRegex(String regex) {
            allowedHostPatterns.add(Pattern.compile(regex));
        }

        static void allowCIDR(String cidr) {
            allowedSubnets.add(Subnet.fromCIDR(cidr));
        }

        static boolean isFirewallActive() {
            return firewallActive;
        }

        static boolean isAllowed(InetSocketAddress addr) {
            if (!firewallActive) {
                return true;
            }
            if (addr == null) {
                return false;
            }
            if (!allowedPorts.contains(addr.getPort())) {
                return false;
            }
            InetAddress ia = addr.getAddress();
            if (ia == null) {
                try {
                    ia = InetAddress.getByName(addr.getHostString());
                }
                catch (UnknownHostException e) {
                    return false;
                }
            }
            for (Subnet s : allowedSubnets) {
                if (!s.contains(ia)) continue;
                return true;
            }
            for (Pattern p : allowedHostPatterns) {
                if (!p.matcher(addr.getHostString()).matches()) continue;
                return true;
            }
            return false;
        }

        static void blockAll() {
            allowedPorts.clear();
            firewallActive = true;
            System.err.println("[Shiro][EnhancedNetworkSecurity] All network access blocked due to integrity violation.");
        }

        private record Subnet(InetAddress network, byte[] mask) {
            static Subnet fromCIDR(String cidr) {
                try {
                    String[] parts = cidr.trim().split("/");
                    InetAddress net = InetAddress.getByName(parts[0]);
                    int prefix = Integer.parseInt(parts[1]);
                    int bytes = net.getAddress().length;
                    byte[] mask = new byte[bytes];
                    int full = prefix / 8;
                    int rem = prefix % 8;
                    for (int i = 0; i < full; ++i) {
                        mask[i] = -1;
                    }
                    if (full < bytes && rem > 0) {
                        mask[full] = (byte)(255 << 8 - rem);
                    }
                    return new Subnet(net, mask);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Invalid CIDR: " + cidr, ex);
                }
            }

            boolean contains(InetAddress addr) {
                byte[] n;
                byte[] a = addr.getAddress();
                if (a.length != (n = this.network.getAddress()).length) {
                    return false;
                }
                for (int i = 0; i < a.length; ++i) {
                    if ((a[i] & this.mask[i]) == (n[i] & this.mask[i])) continue;
                    return false;
                }
                return true;
            }
        }
    }

    private static final class IntegrityChecker {
        private IntegrityChecker() {
        }

        static boolean verifyJar(Path jarPath) {
            String hash = IntegrityChecker.computeSelfHash();
            if ("<error>".equals(hash)) {
                return false;
            }
            System.out.println("[Shiro][Integrity] Current JAR hash: " + hash);
            return true;
        }

        static String computeSelfHash() {
            try {
                URL url = ShiroSecurity.class.getProtectionDomain().getCodeSource().getLocation();
                if (url == null) {
                    return "<unknown>";
                }
                Path jarPath = Path.of(url.toURI());
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                try (InputStream in = Files.newInputStream(jarPath, new OpenOption[0]);
                     DigestInputStream dis = new DigestInputStream(in, md);){
                    byte[] buf = new byte[8192];
                    while (dis.read(buf) != -1) {
                    }
                }
                return IntegrityChecker.hex(md.digest());
            }
            catch (Exception e) {
                System.err.println("[Shiro][Integrity] Failed to compute self-hash: " + String.valueOf(e));
                return "<error>";
            }
        }

        private static String hex(byte[] data) {
            StringBuilder sb = new StringBuilder(data.length * 2);
            for (byte b : data) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
    }

    private static final class HardenedSecurityManager
    extends SecurityManager {
        private HardenedSecurityManager() {
        }

        @Override
        public void checkPermission(Permission perm) {
            if (perm == null) {
                return;
            }
            String name = perm.getName();
            if (perm instanceof ReflectPermission && "suppressAccessChecks".equals(name)) {
                throw new SecurityException("Reflection access blocked by Shiro.");
            }
            if ("exitVM".equals(name) || name.startsWith("exitVM")) {
                throw new SecurityException("System exit blocked by Shiro.");
            }
            if ("setSecurityManager".equals(name)) {
                throw new SecurityException("Cannot replace Shiro SecurityManager.");
            }
        }

        @Override
        public void checkExec(String cmd) {
            throw new SecurityException("Runtime.exec blocked: " + cmd);
        }

        @Override
        public void checkExit(int status) {
            throw new SecurityException("System.exit blocked: " + status);
        }

        @Override
        public void checkCreateClassLoader() {
            throw new SecurityException("Custom ClassLoaders blocked by Shiro.");
        }

        @Override
        public void checkPackageAccess(String pkg) {
            if (pkg != null && pkg.startsWith("java.lang.reflect")) {
                throw new SecurityException("Reflection package access blocked: " + pkg);
            }
        }

        public void checkMemberAccess(Class<?> clazz, int which) {
            if (which != 0) {
                throw new SecurityException("Reflective member access blocked: " + clazz.getName());
            }
        }
    }

    private static final class RuntimeWatchdog {
        private static boolean running = false;
        private static final long INTERVAL = 5000L;
        private static final int SOCKET_THRESHOLD = 1024;

        private RuntimeWatchdog() {
        }

        static void start() {
            if (running) {
                return;
            }
            running = true;
            Thread t = new Thread(() -> {
                RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
                while (true) {
                    try {
                        while (true) {
                            long free;
                            int open;
                            if ((open = RuntimeWatchdog.estimateOpenSockets()) > 1024) {
                                System.err.println("[Shiro][Watchdog] Too many sockets: " + open);
                            }
                            if ((free = Runtime.getRuntime().freeMemory()) < 0x1000000L) {
                                System.err.println("[Shiro][Watchdog] Low memory: " + free);
                            }
                            Thread.sleep(5000L);
                        }
                    }
                    catch (Throwable t1) {
                        System.err.println("[Shiro][Watchdog] Exception: " + String.valueOf(t1));
                        continue;
                    }
                    break;
                }
            }, "Shiro-Watchdog");
            t.setDaemon(true);
            t.setPriority(1);
            t.start();
            System.out.println("[Shiro] Watchdog started.");
        }

        private static int estimateOpenSockets() {
            return (int)(Math.random() * 10.0);
        }
    }

    public static interface UserNotifier {
        public void notifyUser(String var1);
    }
}

