/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.util;

import java.lang.reflect.Field;

public final class ThreadLocalCleaner {
    public static void clearThreadLocals(Thread t) {
        try {
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Object threadLocalMap = threadLocalsField.get(t);
            if (threadLocalMap == null) {
                return;
            }
            Class<?> mapClass = threadLocalMap.getClass();
            Field tableField = mapClass.getDeclaredField("table");
            tableField.setAccessible(true);
            Object[] table = (Object[])tableField.get(threadLocalMap);
            for (int i = 0; i < table.length; ++i) {
                if (table[i] == null) continue;
                table[i] = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void clearCurrent() {
        ThreadLocalCleaner.clearThreadLocals(Thread.currentThread());
    }

    public static void clear(Thread thread) {
        try {
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            threadLocalsField.set(thread, null);
        }
        catch (Throwable threadLocalsField) {
            // empty catch block
        }
        try {
            Field inheritableField = Thread.class.getDeclaredField("inheritableThreadLocals");
            inheritableField.setAccessible(true);
            inheritableField.set(thread, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

