/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.vm;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class OrphanThreadKiller {
    private static final Pattern[] WHITELIST = new Pattern[]{Pattern.compile(".*RenderThread.*", 2), Pattern.compile(".*Main.*", 2), Pattern.compile(".*Server.*", 2), Pattern.compile("Shiro-.*"), Pattern.compile("ForkJoinPool-.*"), Pattern.compile("Netty.*"), Pattern.compile("Thread-.*")};

    private static boolean isWhitelisted(String name) {
        if (name == null) {
            return false;
        }
        for (Pattern p : WHITELIST) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public static void killOrphanThreads() {
        Set threads = Thread.getAllStackTraces().keySet().stream().collect(Collectors.toSet());
        for (Thread thread : threads) {
            try {
                Thread.State st;
                String name;
                if (thread == Thread.currentThread() || thread.isDaemon() || OrphanThreadKiller.isWhitelisted(name = thread.getName()) || (st = thread.getState()) != Thread.State.WAITING && st != Thread.State.TIMED_WAITING && st != Thread.State.BLOCKED) continue;
                System.out.println("[Shiro-VM] Interrupting suspected orphan thread: " + name + " state=" + String.valueOf((Object)st));
                try {
                    thread.interrupt();
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {}
        }
    }
}

