/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.vm;

import com.abdik.shiro.util.DeepNullifier;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StaticFieldCleaner {
    private static final List<String> KNOWN_BLOATERS = new ArrayList<String>();

    public static void cleanStaticCollections(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        try {
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    Map map;
                    if (!Modifier.isStatic(field.getModifiers())) continue;
                    field.setAccessible(true);
                    Object value = field.get(null);
                    if (value == null) continue;
                    if (value instanceof List) {
                        List list = (List)value;
                        if (list.size() <= 1000) continue;
                        DeepNullifier.deepClearList(list);
                        continue;
                    }
                    if (!(value instanceof Map) || (map = (Map)value).size() <= 1000) continue;
                    DeepNullifier.deepClearMap(map);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void cleanKnownBloaters() {
        for (String clazz : KNOWN_BLOATERS) {
            try {
                Class<?> cl = Class.forName(clazz);
                StaticFieldCleaner.cleanStaticCollections(cl);
            }
            catch (ClassNotFoundException cl) {
            }
            catch (Throwable t) {
                System.err.println("[Shiro-VM] StaticFieldCleaner failed on " + clazz + ": " + String.valueOf(t));
            }
        }
    }

    public static void registerBloatingClass(String className) {
        if (className == null || className.isBlank()) {
            return;
        }
        KNOWN_BLOATERS.add(className);
    }

    static {
        KNOWN_BLOATERS.add("me.shedaniel.rei.impl.ClientPluginManager");
        KNOWN_BLOATERS.add("me.shedaniel.rei.api.client.util.ClientEntryRegistry");
    }
}

